<?php

namespace App\Http\Middleware;

use App\Services\ThemeResolver;
use Closure;
use Illuminate\Http\Request;
use Illuminate\View\View;

class SetPortalTheme
{
    public function __construct(private ThemeResolver $resolver) {}

    public function handle(Request $request, Closure $next, string $portal = 'frontend')
    {
        $theme = $this->resolver->resolve($portal, $request);

        View::addNamespace($portal, resource_path("views/themes/{$portal}/{$theme}"));
        View::addNamespace('shared', resource_path('views/shared'));

        return $next($request);
    }
}
