<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\View\View;

class SetRouteTheme
{
    public function handle(Request $request, Closure $next, string $namespace)
    {
        $path = str_replace('_', '/', $namespace);
        View::addNamespace($namespace, resource_path("views/themes/{$path}"));

        return $next($request);
    }
}
