# RELEASE-NOTE v0.1.1 (2025-12-09)

## 修复
- 修复 SQLite 配置：将 `.env` 的 `DB_DATABASE` 改为绝对路径 `D:/Projects/Laravel/Lydiony-Garden/database/database.sqlite`，解决 “Database file at path [laravel] does not exist” 错误
- 增加 `sessions` 表迁移并兼容已有表（`Schema::hasTable('sessions')` 防重复），配合 `SESSION_DRIVER=database`

## 验证
- 迁移执行成功：`php artisan migrate --force`
- 首页会话读写正常

# RELEASE-NOTE v0.1.0 (2025-12-09)

## 新增
- 初始化 Laravel 12 项目，兼容 PHP 8.3+
- 默认使用 SQLite，提供 MySQL / PostgreSQL / SQLite 三种数据库支持
- 生成应用密钥、执行基础迁移（users/cache/jobs）

## 验证
- `composer test` 通过（默认示例用例）
- `vendor\bin\pint --test` 通过（代码风格检查）
- `php artisan about` 显示环境与驱动正常

## 配置
- `.env` 预置常用数据库连接键（`DB_CONNECTION`、`DB_HOST`、`DB_PORT`、`DB_DATABASE`、`DB_USERNAME`、`DB_PASSWORD`）
- 切换到 MySQL：`DB_CONNECTION=mysql`，设置主机/端口/库名/用户/密码后 `php artisan migrate`
- 切换到 PostgreSQL：`DB_CONNECTION=pgsql`，设置主机/端口/库名/用户/密码后 `php artisan migrate`
- 使用 SQLite（默认）：`DB_CONNECTION=sqlite`，数据库文件位于 `database/database.sqlite`

## 备注
- 代码位于 `d:\Projects\Laravel\Lydiony-Garden`，发布说明路径 `dev/release-notes/RELEASE-NOTE.md`
