@php($now = \Carbon\Carbon::now())
@php($first = $now->copy()->startOfMonth())
@php($days = $now->daysInMonth)
@php($start = $first->dayOfWeekIso)
@php($monthName = $now->format('F'))
@php($year = $now->year)
<style>
.hero{padding:0}
.carousel{position:relative;width:100%;border-radius:0;overflow:hidden}
.carousel-track{display:flex;transition:transform .5s ease;height:100%}
.slide{min-width:100%;height:100%;display:flex;align-items:center;justify-content:center;color:#fff;font-size:clamp(18px,3vw,28px)}
.s1{background:linear-gradient(135deg,#667eea,#764ba2)}
.s2{background:linear-gradient(135deg,#ff9966,#ff5e62)}
.s3{background:linear-gradient(135deg,#36d1dc,#5b86e5)}
.carousel-nav{position:absolute;inset:auto 0 12px 0;display:flex;justify-content:center;gap:10px;align-items:center}
.dot{width:10px;height:10px;border-radius:50%;background:#fff;opacity:.6;border:0}
.dot.active{opacity:1}
.carousel-btn{position:absolute;top:50%;transform:translateY(-50%);background:rgba(255,255,255,.7);border:0;border-radius:50%;width:36px;height:36px}
.carousel-btn.prev{left:10px}
.carousel-btn.next{right:10px}
.calendar-section{padding:0;background:#fff}
.calendar-flat{height:100%;width:100%}
.calendar-inner{display:flex;flex-direction:column;height:100%}
.calendar-header{display:flex;justify-content:space-between;align-items:center;padding:8px 10px;border-bottom:1px solid #eee}
.calendar-title{font-size:clamp(16px,2.2vw,22px);font-weight:700}
.calendar-meta{font-size:clamp(12px,1.8vw,14px);color:#666}
.weekday{display:grid;grid-template-columns:repeat(7,1fr);gap:0}
.weekday div{text-align:center;font-size:clamp(11px,1.8vw,13px);color:#888;padding:6px 0;border-bottom:1px solid #eee}
.month-grid{flex:1;display:grid;grid-template-columns:repeat(7,1fr);grid-template-rows:repeat(6,1fr);gap:0}
.day{display:flex;justify-content:center;align-items:center;border:1px solid #efefef;font-size:clamp(14px,2.8vw,18px)}
.day.muted{background:#fafafa}
.day.today{outline:2px solid #1f76ff}
.day.disabled{opacity:.5;pointer-events:none}
.bubble{display:inline-flex;min-width:2.2em;height:2.2em;border-radius:999px;align-items:center;justify-content:center;padding:0 .2em}
.day.reminder .bubble{background:#ff4769;color:#fff}
.pop{position:fixed;inset:0;display:flex;align-items:center;justify-content:center;background:rgba(0,0,0,.35)}
.pop.hidden{display:none}
.pop-content{background:#fff;border-radius:12px;min-width:min(380px,92vw);padding:18px;box-shadow:0 10px 24px rgba(0,0,0,.2)}
.pop-title{font-weight:700;margin-bottom:8px}
.pop-close{margin-top:12px;border:0;background:#1f76ff;color:#fff;border-radius:8px;padding:8px 12px}
@media (max-width:640px){
  .carousel-btn{width:32px;height:32px}
}
</style>
<div class="hero" style="height:50vh">
  <div class="carousel" style="height:100%">
    <button class="carousel-btn prev">‹</button>
    <div class="carousel-track" style="height:100%">
      <div class="slide s1">Slide 1</div>
      <div class="slide s2">Slide 2</div>
      <div class="slide s3">Slide 3</div>
    </div>
    <button class="carousel-btn next">›</button>
    <div class="carousel-nav">
      <button class="dot active" data-index="0"></button>
      <button class="dot" data-index="1"></button>
      <button class="dot" data-index="2"></button>
    </div>
  </div>
</div>
<div class="calendar-section" style="height:50vh">
  <div class="calendar-flat">
    <div class="calendar-inner">
      <div class="calendar-header">
        <div class="calendar-title">{{ $monthName }} {{ $year }}</div>
        <div class="calendar-meta">{{ $now->toDateString() }}</div>
      </div>
      <div class="weekday">
        <div>Mon</div>
        <div>Tue</div>
        <div>Wed</div>
        <div>Thu</div>
        <div>Fri</div>
        <div>Sat</div>
        <div>Sun</div>
      </div>
      <div class="month-grid">
        @php($lead = $start - 1)
        @php($total = 42)
        @php($trail = $total - ($lead + $days))
        @for($i=0;$i<$lead;$i++)
          <div class="day muted"></div>
        @endfor
        @for($d=1;$d<=$days;$d++)
          @php($isToday = $d === (int)$now->day)
          <div class="day {{ $isToday ? 'today' : '' }}" data-day="{{ $d }}"><span class="bubble">{{ $d }}</span></div>
        @endfor
        @for($r=0;$r<$trail;$r++)
          <div class="day muted"></div>
        @endfor
      </div>
    </div>
  </div>
</div>
<div id="calendar-pop" class="pop hidden">
  <div class="pop-content">
    <div class="pop-title"></div>
    <div class="pop-msg"></div>
    <button class="pop-close">关闭</button>
  </div>
</div>
<script>
const track=document.querySelector('.carousel-track');
const dots=[...document.querySelectorAll('.dot')];
let idx=0;function go(i){idx=(i+3)%3;track.style.transform=`translateX(-${idx*100}%)`;dots.forEach((d,j)=>d.classList.toggle('active',j===idx))}
document.querySelector('.carousel-btn.prev').addEventListener('click',()=>go(idx-1));
document.querySelector('.carousel-btn.next').addEventListener('click',()=>go(idx+1));
dots.forEach(d=>d.addEventListener('click',()=>go(parseInt(d.dataset.index))));
setInterval(()=>go(idx+1),5000);
const reminders={2:'示例提醒 A',5:'示例提醒 B',13:'示例提醒 C',21:'示例提醒 D',28:'示例提醒 E'};
document.querySelectorAll('.day[data-day]').forEach(el=>{const d=parseInt(el.dataset.day);if(reminders[d]){el.classList.add('reminder');el.addEventListener('click',()=>{const pop=document.getElementById('calendar-pop');pop.classList.remove('hidden');pop.querySelector('.pop-title').textContent=`${d} 日提醒`;pop.querySelector('.pop-msg').textContent=reminders[d];});}else{el.classList.add('disabled');}});
document.querySelector('#calendar-pop .pop-close').addEventListener('click',()=>document.getElementById('calendar-pop').classList.add('hidden'));
</script>
