<?php

use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Frontend\Auth\LoginController;
use App\Http\Controllers\Frontend\HomeController;
use Illuminate\Support\Facades\Route;

Route::prefix('admin')
    ->name('admin.')
    ->middleware(['web', 'set.portal.theme:admin'])
    ->group(function () {
        Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    });

Route::name('frontend.')
    ->middleware(['web', 'set.portal.theme:frontend'])
    ->group(function () {
        Route::get('/', [HomeController::class, 'index'])->name('home');
    });

Route::prefix('user')
    ->name('user.')
    ->middleware(['web', 'set.portal.theme:frontend', 'set.route.theme:frontend_auth'])
    ->group(function () {
        Route::get('login', [LoginController::class, 'show'])->name('login');
    });
